/*
 *	execc - call texec with default bin directories
 *		prepended to "name".
 */

execc( name , argv )
  char *name;
  char *argv[];
{
	register uid;
	char *cat();

  uid = ( getuid() >> 8 ) & 0377;

  if ( !uid && name[0] != '/' )  {
	texec( cat( "/etc/" , name ) , argv );
  }else
	texec( name , argv );

  if ( name[0] == '/' )
	return( -1 );

  texec( cat( "/bin/" , name ) , argv );
  texec( cat( "/usr/bin/" , name ) , argv );

  if ( !uid )
	texec( name , argv );

  return( -1 );
}


char *cat( s2 , s3 )
  register char *s2, *s3;
{
	char buf[50];
	register char *s1 = buf;

  while(*s1++ = *s2++)  if ( s1 > &buf[sizeof buf] )  return( "?" );
  s1--;
  while(*s1++ = *s3++)  if ( s1 > &buf[sizeof buf] )  return( "?" );

  return( buf );
}


/*
 *	"texec" knows about command files and pascal interpreter
 */

#define	ENOEXEC	8
#define	ENOMEM	12

texec( name , argv )
  register char *name;
  char *argv[];
{
	extern errno;

  execv( name, argv );
  if (errno==ENOEXEC) {
	char *v[256];  register char **vp = &v[1];
	{
		register char **avp = argv;

		*vp++ = name;
		if ( !*avp++ )  {
			*vp++ = name;
			*vp = 0;
		}else
			while ( *vp++ = *avp++ )
				if ( vp > &v[sizeof v] )  {
					prs( "too many args\n" );
					exit( -1 );
				}
		vp = v;
	}
	{
		register pcfd;
		/*
		 *	if file exists but not executable
		 *	it may be a pascal obj file
		 *	magic number = 0404
		 */
		if( (pcfd=open(name,0))>0 ){
			int pcrd, pcmag;

			pcrd = read(pcfd,&pcmag,2); close(pcfd);
			if(pcrd==2)
				if( pcmag==0404 ) {
					*vp = "pcx";
					execv( "/usr/bin/pcx" , vp );
				}
		}
	}
	/*
	 *	not pascal obj must be shell cmd file
	 */
	*vp = "sh";
	execv( "/bin/sh" , vp );
	prs("No shell!\n");
	exit( -1 );	
  }
  if (errno==ENOMEM) {
	prs( name );
	prs(": too large\n");
	exit( -1 );	
  }
}


prs( s )  register char *s;  {  while ( *s )  write( 2 , s++ , 1);  }
