#
/*
 * UNIX fortran/macro linker cross reference
 */

#define	QUABS	102
#define	GOBBLE	512
#define	SCSYM	8
#define	SCRLIST	8
#define	NIL	0
#define	T	01
#define	A	02
#define	S	04
#define	F	010

struct	crdata	{
	int	*crname[2];
	int	*crmod[2];
	int	crflag;
};

struct	crlist	{
	int	*mname[2];
	int	mdef;
	struct	crlist	*mp;
};

struct	csym	{
	int	*cname[2];
	struct	crlist	*ccp;
	struct	csym	*cnext;
};

char	*memlow;
char	*memhigh;
int	fout;
int	infile;
int	flags;

struct csym *chead	NIL;

main(argc,argv)
char **argv;
{
	int	ibuf[QUABS * 5];
	register int i;
	register struct crdata *ccr;
	register char *rcp;

	memhigh = ((memlow = sbrk(GOBBLE)) + GOBBLE);
	if(memlow == -1)
		ferror("Cref core exceeded.");
	infile = *argv[2] - '0';
	fout = *argv[3] - '0';

	rcp = argv[1];
	while(*rcp)
		switch(*rcp++) {

		case ':' :	break;
		case 'f' :	flags =| F;
				break;
		case 't' :	flags =| T;
				flags =& ~S;
				break;
		case 'a' :	flags =| A;
				break;
		case 's' :	flags =| S;
				flags =& ~T;
				break;
		default:	fout = 2;
				printf("Unknown cref option ignored: %c\n",rcp[-1]);
				fout = *argv[3] - '0';

		}
	while(i = read(infile,ibuf,QUABS * 10)) {
		ccr = ibuf;
		do
			adsym(ccr++);
		while(i =- 10);
	}
	prcref();
	exit(0);
}

prcref()
{
	register struct csym *cp;
	register struct crlist *crp;
	register int i;

	cp = chead;
	printf("\n\n\n\n\n********** Global Cross Reference\n\n\n\n");
	while(cp) {
		crp = cp->ccp;
		if(
			((flags&F) && (ldiv(0,cp->cname[1],1600) == 033 || ldiv(0,cp->cname[0],1600) == 033)) ||
			((crp->mp==NIL) && ((flags&T) || ((flags&S) && (crp->mdef))))
		  ) {
			cp = cp->cnext;
			continue;
		}
		radout(cp->cname);
		printf("    ");
		i = 6;
		while(crp)  {
			if(i == 0) {
				i = 6;
				printf("\n\t  ");
			}
			radlout(crp->mname);
			putchar((crp->mdef) ? '#' : ' ');
			printf("   ");
			i--;
			crp = crp->mp;
		}
		cp = cp->cnext;
		putchar('\n');
	}
	printf("\n\n\n");
	flush();
}

radcon(rad,asc)
int	*rad;
char	*asc;
{
	register int w,c1;
	int cc;
	register char *s;
	char *ss;
	extern int ldivr;
	s = asc;
	ss = " abcdefghijklmnopqrstuvwxyz$.0123456789";
	cc = 2;
	do {
		w = *rad++;
		c1 = lrem(0,w,050);
		w  = ldiv(0,w,050);
		w  = ldiv(0,w,050);
		*s++ = ss[w];
		*s++ = ss[ldivr];
		*s++ = ss[c1];
	} while(--cc);
}

radout(p)
int *p;
{
	char rasc[6];
	radcon(p,rasc);
	printf("%.6s",rasc);
}

radlout(p)
int *p;
{
	char rasc[6];
	register char *s;
	register int i,j;
	radcon(p,rasc);
	j = i = 6;
	while(i) 
		if(rasc[--i] == ' ') {
			rasc[i] = 0;
			j = i;
		}
	printf("      " + j);
	printf("%.6s",rasc);
}

char *getcore(n)
{
	register char *w;
	if(memhigh - memlow <= n) {
		if(sbrk(GOBBLE) == -1)
			ferror("Cref core exceeded");
		memhigh =+ GOBBLE;
	}
	w = memlow;
	memlow =+ n;
	return(w);
}

adsym(cccp)
struct crdata *cccp;
{
	register char *rr1,*rr2,*rr3;
	int *cp1;
	cp1 = &chead;
	rr1 = chead;
	rr2 = cccp;
	for(;;) {
		if(rr1==NIL||rr2->crname[0]<rr1->cname[0]||(rr2->crname[0]==rr1->cname[0]&&rr2->crname[1]<rr1->cname[1])) {
			rr3 = getcore(SCSYM);
			rr3->cname[0] = rr2->crname[0];
			rr3->cname[1] = rr2->crname[1];
			rr3->cnext = *cp1;
			*cp1 = rr3;
			rr3 = rr3->ccp = getcore(SCRLIST);
			rr3->mname[0] = rr2->crmod[0];
			rr3->mname[1] = rr2->crmod[1];
			rr3->mdef = rr2->crflag;
			return;
		}
		if(rr1->cname[0]==rr2->crname[0] && rr1->cname[1]==rr2->crname[1]) {
			cp1 = &(rr1->ccp);
			rr1 = rr1->ccp;
			while(rr1) {
				if((flags&A) && (rr1->mname[0]>rr2->crmod[0] ||
					(rr1->mname[0]==rr2->crmod[0]&&rr1->mname[1]>rr2->crmod[1])))
					break;
				cp1 = &(rr1->mp);
				rr1 = *cp1;
			}
			rr1 = getcore(SCRLIST);
			rr1->mp = *cp1;
			*cp1 = rr1;
			rr1->mname[0] = rr2->crmod[0];
			rr1->mname[1] = rr2->crmod[1];
			rr1->mdef = rr2->crflag;
			return;
		}

		cp1 = &(rr1->cnext);
		rr1 = *cp1;
	}
}


ferror(s)
char *s;
{
	printf("%s\n");
	flush();
	exit(1);
}
