/*------------ source/s4/util/setsig.c --------*/
/* char Sccsid [] "@(#)setsig        1.1"; */
# include       <signal.h>
# include       "macros.h"
 
/*
        General-purpose signal setting routine.
        All non-ignored, non-caught signals are caught.
        If a signal other than hangup, interrupt, or quit is caught,
        a "user-oriented" message is printed on file descriptor 2 with
        a number for help(I).
        If hangup, interrupt or quit is caught, that signal
        is set to ignore.
        Termination is like that of "fatal",
        via "clean_up(sig)" (sig is the signal number)
        and "exit(userexit(1))".
 
        If the file "dump.core" exists in the current directory
        the function commits
        suicide to produce a core dump
        (after calling clean_up, but before calling userexit).
*/
 
 
char    *Mesg[NSIG] {
        0,
        0,      /* Hangup */
        0,      /* Interrupt */
        0,      /* Quit */
        "Operation exception",
        "Monitor call",
        "Program event recording",
        "Page translation exception",
        "Floating divide exception",
        "Killed",
        "Specification exception",
        "Segmentation exception",
        "Bad system call",
        "Broken pipe",
        "Alarm clock",
	"Soft kill",
	"Privileged operation exception",
	"Execute exception",
	"Protection exception",
	"Data exception",
	"Fixed point overflow exception",
	"Decimal overflow exception",
	"Decimal divide exception",
	"Exponent overflow exception",
	"Exponent underflow exception",
	"Significance exception",
	"No space or inode on fs",
	"No file structures free in system"
};
 
 
setsig()
{
        extern int setsig1();
        register int j, n;
 
        for (j=1; j<NSIG; j++)
                if (n=signal(j,setsig1))
                        signal(j,n);
}
 
 
char preface[]    "SIGNAL: ";
char endmsg[]     " (help sys.12)\n";
 
setsig1(sig)
int sig;
{
 
        if (Mesg[sig]) {
                write(2,preface,length(preface));
                write(2,Mesg[sig],length(Mesg[sig]));
                write(2,endmsg,length(endmsg));
        }
        else
                signal(sig,1);
        clean_up(sig);
        if(open("dump.core",0) > 0) {
                signal(SIGINS,0);
                abort();
        }
        exit(userexit(1));
}
