#include "../h/param.h"
#include "../h/systm.h"
#include "../h/dir.h"
#include "../h/user.h"
#include "../h/mount.h"
#include "../h/buf.h"
#include "../h/filsys.h"

/*
 * This file contains system calls added at  a m d a h l
 */

/*
 * Freeze system call.
 * Grab a mounted device and set the locks
 * to prevent free blocks and inodes from being
 * allocated or freed. This is used by file-system
 * validation routines.
 */
freeze()
{
        dev_t d;
        struct mount *mp;
        struct filsys *fp;

        if(!suser())
                return;
        d = getmdev();
        if(u.u_error)
                return;
        for(mp = &mount[0]; mp < &mount[NMOUNT]; mp++)
                if(mp->m_bufp != NULL && d == mp->m_dev)
                        goto ffound;
        u.u_error = EINVAL;
        return;

ffound:
        fp = mp->m_bufp->b_un.b_filsys;
        if(fp->s_ronly) {
                u.u_error = EINVAL;
                return;
        }
        if(mp->m_flag & M_FROZEN) {
                u.u_error = EBUSY;
                return;
        }
        while(fp->s_fmod || fp->s_flock || fp->s_ilock) {
                if(fp->s_fmod)
                        update();
                if(fp->s_flock)
                        sleep((caddr_t)&fp->s_flock, PINOD);
                if(fp->s_ilock)
                        sleep((caddr_t)&fp->s_ilock, PINOD);
        }
        mp->m_flag |= M_FROZEN;
        fp->s_flock++;
        fp->s_ilock++;
}

/*
 * Thaw system call.
 * Verify argument, read in super block, and release locks.
 */
thaw()
{
        dev_t d;
        struct mount *mp;
        struct filsys *fp;
        struct buf *bp;

        if(!suser())
                return;
        d = getmdev();
        if(u.u_error)
                return;
        for(mp = &mount[0]; mp < &mount[NMOUNT]; mp++)
                if(mp->m_bufp != NULL && d == mp->m_dev)
                        goto tfound;
        u.u_error = EINVAL;
        return;

tfound:
        if((mp->m_flag & M_FROZEN) == 0) {
                u.u_error = EINVAL;
                return;
        }
        bp = bread(d, SUPERB);
        bcopy(bp->b_un.b_addr, mp->m_bufp->b_un.b_addr, BSIZE);
        fp = mp->m_bufp->b_un.b_filsys;
        brelse(bp);
        fp->s_flock = 0;
        wakeup((caddr_t)&fp->s_flock);
        fp->s_ilock = 0;
        wakeup((caddr_t)&fp->s_ilock);
        mp->m_flag &= ~M_FROZEN;
        fp->s_fmod = 1;
}

/*
 *  Issue a CP command.
 */
cpcmnd()
{
        char *cp;
	caddr_t ap;
        static char cpbuf[150];
	struct a {
		caddr_t cmdp;
	};

        cp = cpbuf;
        ap = ((struct a *)u.u_ap)->cmdp;
        if(suser()) {
                while(*cp++ = fubyte(ap++));
		u.u_error = cpcmd(cpbuf);
        }
}

/*
 * Pass a command to CP if we're running under VM
 * Called by other parts of kernel as well as cpcmnd
 */
cpcmd(s)
char *s;
{
        char cmdbuf[136], *p;
        int n;
        extern char atetab[];

        if(vm) {
                p = cmdbuf;
                while(*s) *p++ = atetab[*s++];
                n = p - cmdbuf;
                if(n) return(d_cpcmd(cmdbuf, n));
        }
        return(-1);
}
 
/* 
 * Set user information.
 */
setinf()
{
	register struct a {
		caddr_t infp;
	} *ap;

	ap = (struct a *)u.u_ap;
	if(suser()) {
		if(copyin(ap->infp, u.u_info, INFSIZE))
			u.u_error = EFAULT;
	}
}
 
/*
 * Get user information.
 */
getinf()
{
	register struct a {
		caddr_t infp;
	} *ap;

	ap = (struct a *)u.u_ap;
	if(copyout(u.u_info, ap->infp, INFSIZE))
		u.u_error = EFAULT;
}

/*
 * Pass back virtual machine ID
 */
vmid()
{
	char ebcid[8], *cp;
	struct a {
		caddr_t idp;
	};
	caddr_t up;
	extern char etatab[];

	up = ((struct a *)u.u_ap)->idp;
	if(vm) {
		d_vmuser(ebcid);
		for(cp = ebcid; cp < &ebcid[8] && *cp != 0x40; cp++)
			subyte(up++, etatab[*cp]);
	}
	subyte(up, 0);
}
