#include "omak.h"

/*
 *  symbol table routines
 */

SYM *lookup(p)
   char *p;  {
		         SYM *s;
                         int i;

			for (s = symbols; s < symbole; s++) {
			        i = 0;
				while( s->name[i] == p[i] ) {
                                      if ( i == 7) return(s);
				      if (s->name[i++] == '\0') return(s);
			           }
			    }

			 return(0);
		 }

SYM *addrlook(addr)
   int addr;  {
               SYM *s;

			for (s = symbols; s < symbole; s++) {
				      if (s->val > addr) return(--s);
			    }
                        return(0);
              }

/*  printstack - print a stack trace
 *     uses 'C' calling conventions
 *
 *    r10 -> address of current function
 *    r12 -> save area for registers
 *    saved r13 -> arguments
 *    saved r12 -> end of arguments
 */

printstack(addr) int *addr; {

	register int p, *i, *savereg;
        int lastfunc, *argp, *lastarg;
        SYM *sym;
        char string[80];
        int strptr, j;

        if (addr) {
                    savereg = *(addr + 12) & STACKTOP;
	            lastfunc = *(addr + 10);
                   }
          else {
	          savereg = gpr_ptr[12] & STACKTOP;
	          lastfunc = gpr_ptr[10];
               }
	aptstr(aptout,"stack trace:%s",blankchr);
	aptio(aptout,0);
	while (savereg != 0) {
		argp = *(savereg + 13) & STACKTOP;
                lastarg = *(savereg + 12) & STACKTOP;
		if (lastarg == 0) lastarg = argp + 2;
		sym = addrlook(lastfunc);
                string[0] = ' ';
                string[1] = ' ';
                string[2] = ' ';
                for(j=3; j<80; j++) string[j] = '\0';
                strptr = 3;
                if (sym == 0) {
                               aptstr(aptout,"%x",lastfunc);
                               for (j=0; aptout[j] != '\0'; j++)
                                         string[strptr++] = aptout[j];
                               }
                  else
                        for (j=0; (sym->name[j] != '\0') && (j < 8); j++)
                                          string[strptr++] = sym->name[j];
                string[strptr++] = '(';
		for (i = argp; i < lastarg; i++) {
			aptstr(aptout,"%x",*i);
                        for (j=0; aptout[j] != '\0'; j++)
                             string[strptr++] = aptout[j];
			if (i != lastarg-1) string[strptr++] = ',';
                   }
                string[strptr] = ')';
                aptstr(aptout,"%s",string);
                aptio(aptout,0);
                lastfunc = *(savereg + 10);
                savereg = *(savereg + 12) & STACKTOP;
         }
      }
