/*
 * standard I/O library error handling
 *
 * the routine "onerror" is called in a signal like manner
 * to specify the action to take when a given error occurs
 *
 * "_stdioerr" processes a given error according to the desired action
 */

#include <stdio.h>
#include <stdioerr.h>

_INTFUNC onerror(errno, action)
register int errno;
_INTFUNC action;{

	_INTFUNC oldact;

	if (errno < EPERM || errno > EMAXERR ||
	   (errno > ERANGE && errno < ESCANPTR))
		return(_stdioerr(EINVAL, "onerror"));
	if (errno >= ESCANPTR)
		errno = errno-ESCANPTR+ERANGE+1;
	oldact = _erract[errno];
	_erract[errno] = action;
	return(oldact);
	}

/*VARARGS2*/
_stdioerr(errno, funcname, a, b, c, d, e)
register int errno;
char *funcname;{

	register _INTFUNC eact;
	extern char *cmdname;
	int oerrno;

	oerrno = errno;
	fflush(stdout);
	if (errno < EPERM || errno > EMAXERR ||
	   (errno > ERANGE && errno < ESCANPTR))
		return(_stdioerr(EINVAL, "_stdioerr"));
	if (errno >= ESCANPTR)
		errno = errno-ESCANPTR+ERANGE+1;
	if ((eact = _erract[errno]) == EIGNORE)
		return(_errinfo[errno]._defval);
	if (eact != ECATCH)
		return((*eact)(oerrno, funcname, a, b, c, d, e));
	fprintf(stderr, "\n%s: ", cmdname);
	if (funcname != 0)
                fprintf(stderr, "%s: ", funcname);
	fprintf(stderr, _errinfo[errno]._errmsg, a, b, c, d, e);
	putc('\n', stderr);
	exit(errno);
	}
