#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <a.out.h>
#include <pwd.h>
#include <stdioerr.h>
#include <errno.h>

#define DASH            '-'
#define UNSHARED        'u'
#define KEEP            'k'
#define MODE            'm'
#define OWNER           'o'

#define DEFMODE         0775

extern  char    *cmdname;
char    usage[] = "Usage: %s [-m mode] [-o owner] [-u] [-k] fromfile tofiles ...\n";
char    bin[] = "bin";
char    uflg;                           /* unshared text flag */
char    kflg;                           /* keep flag */

/*
 * Copy one file to another and, if specified, set the mode and owner,
 * and create appropriate links.
 */
main(argc, argv)
int     argc;
char    **argv;
{
	struct  passwd  *getpwnam();
        struct  passwd  *pw;
	int     mode = 0;
	char    *fromfile = NULL;
	char    *tofile = NULL;
	char    *owner = NULL;
	char    *malloc();
	char    *d;

	onerror(ETXTBSY, EIGNORE);
	argv++;
	argc--;
	while ((argc > 0) && (**argv == DASH)) {
                switch (*(*argv+1)) {
                case MODE:
			if (argc-- <= 0)
                                use();
                        for (d = *++argv; *d; d++)
                                mode = mode*8 + *d - '0';
			break;
		case OWNER:
			if (argc-- <= 0)
                                use();
			owner = *++argv;
			break;
                case UNSHARED:
                        uflg++;
                        break;
                case KEEP:
                        kflg++;
                        break;
                default:
			use();
                }
		argv++;
		argc--;
	}
	if (argc < 2)
		use();
	fromfile = *argv++;
	tofile = *argv++;
	argc -= 2;

	if (mode == 0)
		mode = DEFMODE;
	if (owner == NULL)
		owner = bin;

        if (uflg && (mode & S_ISVTX)) {
                fprintf(stderr, "%s: cannot have unshared sticky text\n", cmdname);
                exit(1);
        }
	/*
	 *  Get the password entry for the owner to be.
	 */
        if ((pw = getpwnam(owner)) == NULL) {
                fprintf(stderr, "%s: %s: bad owner\n", cmdname, owner);
                exit(1);
	}

	install(fromfile, tofile, mode, pw);
	while (argc-- > 0) {
                if (dolink(tofile, *argv) == 0)
                        install(fromfile, *argv, mode, pw);
		argv++;
	}
	if (!kflg)
                unlink(fromfile);
}
/*
 *  install - install the command.
 *  If it is executable, strip it.
 *  Set the mode and owner after it is installed.
 */
install(fromfile, tofile, mode, pw)
char    *fromfile;
char    *tofile;
int     mode;
struct  passwd  *pw;
{
	int     i, size, c;
        FILE    *ffp;
        FILE    *tfp;
        struct  exec    hdr;            /* a.out header */

	if ((ffp = fopen(fromfile, "r")) == NULL) {
		fprintf(stderr, "%s: %s: unable to open\n", cmdname, fromfile);
		exit(1);
	}
	fread((char *)&hdr, sizeof(hdr), 1, ffp);
	if (!uflg && hdr.a_magic == A_MAGIC1) {
                fprintf(stderr, "%s: %s: must be shared text\n", cmdname, fromfile);
                exit(1);
        }
	remove(tofile);
	if ((tfp = fopen(tofile, "w")) == NULL) {
                fprintf(stderr, "%s: %s: unable to open\n", cmdname, tofile);
                exit(1);
        }
	/*
	 * Move the file; strip the symbol table of an executable one
	 */
	if (hdr.a_magic == A_MAGIC1 || hdr.a_magic == A_MAGIC2) {
                hdr.a_syms = 0;
                hdr.a_flag |= 1;
                fwrite((char *)&hdr, sizeof(hdr), 1, tfp);
                size = hdr.a_text + hdr.a_data;
                for (i = 0; i < size; i++)
                        putc(getc(ffp), tfp);
        } else {
		rewind(ffp);
		while ((c = getc(ffp)) != EOF)
			putc(c, tfp);
	}
	fclose(ffp);
	fclose(tfp);
	chown(tofile, pw->pw_uid, pw->pw_gid);
	chmod(tofile, mode);
}
/*
 *  remove - remove a file.  This is tricky if the file
 *  is shared text and is currently busy.  In this case,
 *  link to it under another name and then remove it.
 */
remove(name)
char    *name;
{
	char    nambuf[100];
	char    *mktemp();
	extern  int     errno;

	if (unlink(name) == -1) {
		if (errno == ETXTBSY) {
                        strcpy(nambuf, name);
                        strcat(nambuf, ".rmXXXXX");
                        mktemp(nambuf);
                        if (link(name, nambuf) != 0) {
                                fprintf(stderr, "%s: %s: unable to link\n", cmdname, name);
                                exit(1);
                        }
                        unlink(name);
                } else if (errno != ENOENT) {
			fprintf(stderr, "%s: unable to unlink %s, errno %d\n",
				cmdname, name, errno);
			exit(1);
		}
	}
}
/*
 *  dolink - create any links
 *  Remove the link first, and then link to file just installed.
 */
dolink(fromfile, lnkname)
char    *fromfile;
char    *lnkname;
{
	extern  int     errno;

	remove(lnkname);
	if (link(fromfile, lnkname) == -1) {
		if (errno != EXDEV)
			fprintf(stderr, "%s: ln %s %s failed: errno: %d\n",
				cmdname, fromfile, lnkname, errno);
                return(0);
	}
	return(1);
}

use()
{
        fprintf(stderr, usage, cmdname);
	exit(1);
}
