/*
 * p/n:
 * Program name:      Dump Formatter memory access
 * Author:            Alan Ballard
 * Backup:
 *
 * Description:
 *    This component contains memory accessing routines used by the
 *    dump formatter.
 *    These routine will access real memory or a core image /DUMP file.
 *    Different versions of these routines will be required for use with
 *    Omak, and for accessing a VM dump file.
 *
 */

#include <stdio.h>

#define OFFSET 0       /* offset type for fseek - offset from 0 */
#define BYTES  1       /* item size for fread */
#define MAXBLK 4096    /* max length for request to getblk */

char   buf[MAXBLK];  /* page buffer for returning required text in. */

FILE   *memfd;         /* file for reading memory */

/*
 *  memop opens the memory file.
 */
memop(mem)
char    *mem;          /* The name of the memory file */
{
        memfd = fopen(mem, "r");
        if (memfd == NULL)
                error(1,"can't open memory file %s", mem);
}

/*
 * getblk: main memory access routine.  Returns the address of
 * a buffer contain the requested bytes.
 * Returns -1 if invalid address or length
 *
 * Note the same buffer is used for each request, so use of the returned
 * value must be completed before the next request.
 * (This definition is so that Omak can just return the actual
 * address, without needing a buffer.)
 */

getblk(memaddr,reqlen)
int  memaddr;          /* Address of block required */
int  reqlen;           /* Number of bytes. Must be <= MAXBLK */
{
        register lenmem;
        if  (reqlen <= 0 || reqlen > MAXBLK)
                return(-1);

        /* First position memory stream at desired address */
        fseek(memfd,memaddr,OFFSET);

        /* Next read the block as requested */
        lenmem = fread(buf,BYTES,reqlen,memfd);

        /* Now return what we got, if it was enough */
        if (lenmem == reqlen)
                return((int) buf);
        else
                return(-1);
}

/*
 *  Simple routine to just fetch up to a word from the
 *  memory file (without interfering with current use of buf).
 */
int getbytes(memaddr,n)
int memaddr;         /* address of bytes to retrieve */
int n;               /* number of bytes {= 4) */
{
        int res = 0;            /* place to build result */
        register char *cheat;   /* used to allow treating res as char */

        if (n < 1 || n > 4)
                return (-1);

        /* Position memory stream at desired address */
        fseek(memfd,memaddr,OFFSET);

        /* Next read the block as requested */
        cheat = (char *) &res;
        fread(cheat+4-n, BYTES, n, memfd);

        /* Now return what we got */
        return(res);
}

