/*
*  Start accounting on file named in /etc/acctfile
*/

#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <sys/acctfile.h>


main()
{
        char buf[100];
        char *fn;
	char *fp, mesg[100];
        struct stat stx, sty;
	int  c;
        FILE *fd;
	extern errno;

	/* get accounting file name */
	fd = fopen("/etc/acctfile", "r");
	if(fd == NULL)
		printf("Cannot open /etc/acctfile\n");
	else {
		fp = buf;
		while((c = getc(fd)) != '\n') {
			if (c == EOF) {
				printf("Cannot read /etc/acctfile\n");
				break;
			}
			*fp++ = c;
		}
		*fp = '\0';
		fclose(fd);
	}
	fn = buf;

	/* check that it is valid */
	if (strcmp(fn, filex) != 0 && strcmp(fn, filey) != 0) {
		/* nope, so pick most recently updated */
		stat(filex, &stx);
		stat(filey, &sty);
		if(stx.st_mtime < sty.st_mtime)
			fn = filey;
		else
			fn = filex;
	        sprintf(mesg, "Bad acct file!!  Accounting on %s",
		        fn);
	        notify("adm", mesg, 1);
	        puts(mesg);
	}

	if(stat(fn, &stx)) {
		if(creat(fn, 0644) < 0) {
			perror("accton");
			exit(1);
		}
	}
	if(acct(fn))
		perror("accton");
}
