/*
 * Opr - print files to VM printer.
 */
 
#include  <stdio.h>
#include  <pwd.h>

#define   SLEEPSEC   5
#define   CLASS     23
#define   COPY      30
#define   HOLD      33
#define   TO        40
#define   UID       44
#define   BIN       26
#define   TAG       19
 
/*                  0         1         2         3         4         5 */
/*                  012345678901234567890123456789012345678901234567890 */
char    cpspool[70] =
                   "CP SPOOL PRINTER CLASS T COPY 01 NOHOLD FOR *      ";
char    cptag[70] =
                   "CP TAG DEV PRINTER          ";
char    cpclose[70];
char    nname[70];
char    bin[70];
char    buf[4096];
extern  char *cmdname;
 
FILE    *infp;
int     nflag;
int     bflag;
int     headct;
int     ncopies;  /* Passed to oprd for accounting purposes.            */
                  /* If output is not spooled for another userid, then  */
                  /* oprd will tell the system how many lines were      */
                  /* printed. It must know the number of copies to      */
                  /* do this.                                           */
int     multcopy; /* Non-null if copies parameter given - used by oprd. */
                  /* Required because oprd must output a final form     */
                  /* feed so that subsequent copies will be page        */
                  /* aligned.                                           */
char    *Tfile;
int     conflict;       /* check for comflict: -u and -v both specified */
 
opr(argc, argv)
int     argc;
char    **argv;
{
        char    *ap;
 
        if(!defaults())
		return(0);
        while (--argc > 0 && **++argv == '-'){
                ap = *argv + 1;
		/*
		 * Flag(s) with no following argument.
		 */
		switch (*ap) {
                case 'h':
                        cpspool[HOLD] = ' ';
                        cpspool[HOLD + 1] = ' ';
                        continue;
                }
                if (--argc <= 0) {
                        fprintf(stderr, "%s: arg count\n", cmdname);
                        return(0);
                }
		/*
                 * Flags which require following argument.
		 */
                switch (*ap) {
                case 'b':
			sprintf(bin, "DIST BIN-%s", *++argv);
                        break;
                case 'c':
                        if(!class(*++argv))
				return(0);
                        break;
                case 'n':
			nflag = 1;
			sprintf(nname, "NAME %.24s", *++argv);
                        break;
                case 'u':
			if (conflict++) {
				fprintf(stderr, "%s: cannot have both -u and -v options at once.\n", cmdname);
				return(0);
			}
                        userid(*++argv);
                        break;
                case 'v':
			if (conflict++) {
				fprintf(stderr, "%s: cannot have both -u and -v options at once.\n", cmdname);
				return(0);
			}
                        vmidto(*++argv);
                        break;
                case 'p':
                        copies(*++argv);
			multcopy = 1;
                        break;
                case 't':
                        bldtag(*++argv);
                        break;
		case 'T':
			Tfile = *++argv;
			break;
                default:
                        fprintf(stderr, "%s: invalid argument %s\n", cmdname, *argv);
                        return(0);
                }
                if (ap[1]) {
                        fprintf(stderr, "%s: improper argument: %s\n", cmdname, --ap);
			return(0);
		}
        }
        if (argc > 0 && !nflag)
		sprintf(nname, "NAME %.24s", *argv);
	sprintf(cpclose, "CP CLOSE PRINTER %s %s", bin, nname);
        if(!tmphdr())
		return(0);
        if(argc == 0) {
		infp = stdin;
                if(!copy())
			return(0);
	}
        else
                while(argc-- > 0) {
			if (access(*argv, 4) == -1) {
                                fprintf(stderr, "%s: read access denied to %s\n", cmdname, *argv);
                                return(0);
                        }
                        if ((infp = fopen(*argv++, "r")) == NULL) {
                                fprintf(stderr, "%s: cannot open: %s\n", cmdname, *argv);
                                return(0);
                        }
                        if(!copy())
				return(0);
                        fclose(infp);
                        argv++;
                }
        return(1);
}
 
/*
 * Get bin number or vm id and logon id from pwent.
 */
defaults()
{
        struct passwd *pwent;
        struct passwd *getpwnam();
        struct passwd *getpwuid();
	char *getlogin();
	char *log;

	log = getlogin();
	if(log == NULL)
		pwent = getpwuid(getuid());
        else
                pwent = getpwnam(log);
        if(pwent == NULL) {
                fprintf(stderr, "%s: no entry in /etc/passwd (pwent failed)\n", cmdname);
                return(0);
        }
	sprintf(bin, "DIST BIN-%s", pwent->pw_binno);
        userid(pwent->pw_vmid);
	return(1);
}
 
/*
 * Copy the input file to the output file.
 */
copy()
{
	char    pre[4];
	char    *log;
	char    *getlogin();
	struct  passwd *getpwent();
        int     n;
 
	if(headct++ == 0) {
                /*
                 * On the first file,
                 * If the first three line are not blank...
                 *
                 * Since IBM starts at line 4 and we start at line 1, put
                 * out 63 lines (66 lines per page - 4 + 1).
                 * Might as well print a message as well.
                 */
                log = getlogin();
                if(log == NULL)
                        log = (getpwent(getuid()))->pw_name;
		fread(pre, 1, 1, infp);
		if (pre[0] == '\f')
			putc('\f', stdout);
		else {
                        fread(pre+1, 1, 2, infp);
                        if(pre[0] == '\n' && pre[1] == '\n' && pre[2] == '\n')
			        putc('\f', stdout);
                        else {
                                sprintf (buf, "\fUTS output for %s %s", log, ctime(time()));
                                fwrite(buf, 1, strlen(buf), stdout);
                                for (n = 0; n < 62; n++)
                                        buf[n] = '\n';
                                fwrite(buf, 1, 62, stdout);
                                fwrite(pre, 1, 3, stdout);
                        }
		}
	}
        while ((n = fread(buf, 1, 4096, infp)) > 0) {
                if (fwrite (buf, 1, n, stdout) != n) {
                        fprintf(stderr, "%s: error writing spool file\n", cmdname);
                        return(0);
                }
        }
	return(1);
}
 
/*
 * Check class, then move it to the cp spool command.
 */
class (cp)
char    *cp;
{
        if (*cp >= 'a' && *cp <= 'z')
                *cp += 'A' - 'a';
        if ((*cp >= 'A' && *cp <= 'Z') ||
                (*cp >= '0' && *cp <= '9'))
                cpspool[CLASS] = *cp;
        else {
                fprintf(stderr, "%s: invalid class: %c\n", cmdname, *cp);
                return(0);
        }
	return(1);
}
 
 
/*
 * Move vm userid into cpspool command.
 */
userid (up)
char    *up;
{
        char    *cp;
        char    c;
 
        if (*up) {
                cp = cpspool + UID;
                while ((c = *up++) != '\0') {
                        if (c >= 'a' && c <= 'z')
                                c += 'A' - 'a';
                        *cp++ = c;
                }
                while (cp < cpspool + UID + 8)
                        *cp++ = ' ';
        }
}
  
/*
 * Move vm id to be spooled TO into cpspool command.
 */
vmidto(up)
char    *up;
{
        char    *cp;
        char    c;
 
        if (*up) {
		cpspool[TO] = 'T';
		cpspool[TO + 1] = 'O';
		cpspool[TO + 2] = ' ';
                cp = cpspool + UID;
                while ((c = *up++) != '\0') {
                        if (c >= 'a' && c <= 'z')
                                c += 'A' - 'a';
                        *cp++ = c;
                }
                while (cp < cpspool + UID + 8)
                        *cp++ = ' ';
        }
}
  
/*
 * Check number of copies, then move to cp spool command.
 */
copies (cp)
char    cp[];
{
        if ((cp[0] >= '0' && cp[0] <= '9') &&
          ((cp[1] == '\0') || (cp[1] >= '0' && cp[1] <= '9'))){ 
                if (cp[1] == '\0')
                        cpspool[COPY + 1] = cp[0];
                else {
                        cpspool[COPY] = cp[0];
                        cpspool[COPY + 1] = cp[1];
                }
        }
}

/*
 * Copy tag information to the cptag command.
 */
bldtag(cp)
char *cp;
{
	int i;

	for (i = 0; cp[i]; i++)
		if (cp[i] >= 'a' && cp[i] <= 'z')
			cptag[TAG + i] = cp[i] - 'a' + 'A';
		else
		        cptag[TAG + i] = cp[i];
}

 
tmphdr()
{
	char    *ctime();
	char    banr[100];
	char    *log;
	char    *getlogin();
	char    *vmid();
	FILE    *fp;
	FILE    *pfp;
	struct  passwd *getpwent();
	struct  passwd *pw;
	int     c;
	register n;

	log = getlogin();
	pw = getpwent(getuid());
	if (log == NULL)
		log = pw->pw_name;

        fprintf(stdout, "%s\n", cpspool);
        fprintf(stdout, "%s\n", cpclose);
        fprintf(stdout, "%s\n", cptag);
        fprintf(stdout, "%s\n", log);
        fprintf(stdout, "%d\n", multcopy);
        if (cpspool[UID] == '*' ||
                  (cpspool[UID] == 'A' &&
                   cpspool[UID + 1] == 'U'))
                ncopies = atoi(&cpspool[COPY]);
        else
                ncopies = 0;
        fprintf(stdout, "%d\n", ncopies);
	/*
	 * Microfiche titles must be first in the output.
	 */
	if (Tfile) {
		fp = fopen(Tfile, "r");
		if (fp == NULL) {
			fprintf(stderr, "%s: cannot open %s\n", cmdname, Tfile);
			return(0);
		}
		while((n = fread(buf, 1, 4096, fp)) > 0)
			fwrite(buf, 1, n, stdout);
		fclose(fp);
	}
	return(1);
}

