#define SUFFIX          "+"             /* savefile suffix */
#define CSUFFIX         '+'             /* savefile suffix */
#define MAXLINE         512
#define CNTRLCHAR       '%'             /* save/rest control character */

#define BLANK           ' '
#define COMMA           ','
#define PERIOD          '.'
#define SLASH           '/'
#define ESCAPE          '\\'
#define EOS             '\0'
#define NEWLINE         '\n'
/*
 * Save/rest flags
 */
#define DASH            '-'
#define COMMENTS        'c'             /* input/output comments */
#define FORCE           'f'             /* force option */
#define OUTPUT          'o'             /* redirect output */
#define VERSION         'v'             /* request specific version */
#define MAXVERS         'n'             /* max # of saved versions */
#define REMOVE          'r'             /* remove the source after save */
/*
 * Savefile keyletters
 */
#define CMT             'C'             /* comment keyletter */
#define INFO            'I'             /* misc information keyletter */
#define NVERSIONS       'V'             /* number of versions keyletter */
#define ENDVER          'E'             /* end of a version */
/*
 * diff commands
 */
#define ADD             'a'
#define DELETE          'd'
#define CHANGE          'c'
/*
 *  structure for each version of a savefile
 */
struct  version {
	struct  version *v_next; /* linked list */
	char    *v_sptr;        /* ptr to start of version info */
	char    *v_ptr;         /* ptr within version info */
	char    *v_eptr;        /* ptr to end of version info */
	int     v_ln;           /* line number of input file */
	int     v_start;        /* starting line number for this cmd */
	int     v_dlen;         /* number of lines to delete */
	char    v_cmd;          /* current diff command */
};
/*
 *  structure for comments associated with savefiles or SCCSfiles.
 */
struct  comment {
	struct  comment *c_next;        /* next comment line */
	char    *c_text;                /* a line of comment text */
};
